<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
    <title>تصفية البيانات</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.15/css/bootstrap-multiselect.css">
    <style>
        /* يمكنك إضافة أي تنسيقات إضافية هنا */
        th a {
            text-decoration: none;
            color: black;
        }
        th a:hover {
            color: #000;
        }
        .sort-arrow {
            display: inline-block;
            vertical-align: middle;
            margin-left: 10px;
        }
    </style>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.15/js/bootstrap-multiselect.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#variant-multiselect').multiselect({
                includeSelectAllOption: true,
                nonSelectedText: 'Select an Option'
            });
        });
        
        function removeSpaces(input) {
            input.value = input.value.replace(/\s+/g, '');
        }

        $(document).ready(function() {
            $('#Request_move_vehicles_form').on('change', 'input, select', function() {
                // إرسال النموذج تلقائياً بعد تغيير أي حقل
                $('#Request_move_vehicles_form').submit();
            });
        });
    </script>
</head>
<body>
    <form method="GET" action="" id="Request_move_vehicles_form">
        VIN: <input type="text" id="VINInput1" name="vin" value="<?php echo isset($_GET['vin']) ? $_GET['vin'] : ''; ?>" oninput="removeSpaces(this)">
        Model: <input type="text" name="model" value="<?php echo isset($_GET['model']) ? $_GET['model'] : ''; ?>" oninput="removeSpaces(this)">
        
        Variant:
        <select id="variant-multiselect" name="variant[]" multiple>
            <?php
            // تضمين ملف الاتصال بقاعدة البيانات
            include('config.php');

            // استعلام SQL لجلب القيم الفريدة من العمود Variant
            $variantSql = "SELECT DISTINCT Variant FROM change_stock_1";
            $variantResult = $conn->query($variantSql);

            if ($variantResult->num_rows > 0) {
                while($variantRow = $variantResult->fetch_assoc()) {
                    $selected = isset($_GET['variant']) && in_array($variantRow['Variant'], $_GET['variant']) ? 'selected' : '';
                    echo "<option value='" . $variantRow['Variant'] . "' $selected>" . $variantRow['Variant'] . "</option>";
                }
            }
            ?>
        </select>
        
        <!-- إضافة حقول التاريخ والوقت -->
        Date From: <input type="datetime-local" name="date_from" value="<?php echo isset($_GET['date_from']) ? $_GET['date_from'] : ''; ?>">
        Date To: <input type="datetime-local" name="date_to" value="<?php echo isset($_GET['date_to']) ? $_GET['date_to'] : ''; ?>">
        
        <!-- إضافة حقل لتحديد عدد الصفوف المرغوب عرضها في الصفحة -->
        Rows per page: <input type="number" name="rows_per_page" value="<?php echo isset($_GET['rows_per_page']) ? $_GET['rows_per_page'] : 10; ?>" min="1">
        
        <input type="submit" value="Filter">
    </form>

    <?php
    // الحصول على قيم الفلاتر من النموذج
    $vinFilter = isset($_GET['vin']) ? $_GET['vin'] : '';
    $modelFilter = isset($_GET['model']) ? $_GET['model'] : '';
    $variantFilter = isset($_GET['variant']) ? $_GET['variant'] : [];
    $dateFrom = isset($_GET['date_from']) ? $_GET['date_from'] : '';
    $dateTo = isset($_GET['date_to']) ? $_GET['date_to'] : '';
    $orderBy = isset($_GET['order_by']) ? $_GET['order_by'] : 'VIN';
    $orderDir = isset($_GET['order_dir']) && strtolower($_GET['order_dir']) === 'desc' ? 'DESC' : 'ASC';
    $rowsPerPage = isset($_GET['rows_per_page']) ? intval($_GET['rows_per_page']) : 10;
    $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;
    $offset = ($currentPage - 1) * $rowsPerPage;

    // الشرط الثابت
    $fixedCondition = "Status = 'In Stock'";

    // إنشاء جزء من استعلام SQL للفلاتر
    $whereClauses = [];
    if ($vinFilter) {
        $whereClauses[] = "VIN LIKE '%" . $conn->real_escape_string($vinFilter) . "%'";
    }
    if ($modelFilter) {
        $whereClauses[] = "Model LIKE '%" . $conn->real_escape_string($modelFilter) . "%'";
    }
    if (!empty($variantFilter)) {
        $variants = array_map(function($variant) use ($conn) {
            return "'" . $conn->real_escape_string($variant) . "'";
        }, $variantFilter);
        $whereClauses[] = "Variant IN (" . implode(',', $variants) . ")";
    }
    if ($dateFrom) {
        $whereClauses[] = "Date_last_action >= '" . $conn->real_escape_string($dateFrom) . "'";
    }
    if ($dateTo) {
        $whereClauses[] = "Date_last_action <= '" . $conn->real_escape_string($dateTo) . "'";
    }

    // إضافة الشرط الثابت إلى شروط الفلترة
    $whereClauses[] = $fixedCondition;

    // دمج شروط الفلترة في الاستعلام
    $whereSQL = '';
    if (count($whereClauses) > 0) {
        $whereSQL = "WHERE " . implode(' AND ', $whereClauses);
    }

    // استعلام SQL لجلب الأعمدة المطلوبة من الجدول مع شروط الفلترة والترتيب وتقسيم الصفحات
    $sql = "SELECT VIN, Model, Variant, Date_last_action FROM change_stock_1 $whereSQL ORDER BY $orderBy $orderDir LIMIT $rowsPerPage OFFSET $offset";
    $result = $conn->query($sql);

    // التحقق من وجود نتائج
    if ($result->num_rows > 0) {
        // طباعة النتائج في شكل جدول
        echo "<table border='1'>
                <tr>
                    <th>#</th>
                    <th><a href='?" . http_build_query(array_merge($_GET, ['order_by' => 'VIN', 'order_dir' => $orderBy === 'VIN' && $orderDir === 'ASC' ? 'DESC' : 'ASC'])) . "'>VIN" . ($orderBy === 'VIN' ? ($orderDir === 'ASC' ? '▲' : '▼') : '▲▼') . "</a></th>
                    <th><a href='?" . http_build_query(array_merge($_GET, ['order_by' => 'Model', 'order_dir' => $orderBy === 'Model' && $orderDir === 'ASC' ? 'DESC' : 'ASC'])) . "'>Model" . ($orderBy === 'Model' ? ($orderDir === 'ASC' ? '▲' : '▼') : '▲▼') . "</a></th>
                    <th><a href='?" . http_build_query(array_merge($_GET, ['order_by' => 'Variant', 'order_dir' => $orderBy === 'Variant' && $orderDir === 'ASC' ? 'DESC' : 'ASC'])) . "'>Variant" . ($orderBy === 'Variant' ? ($orderDir === 'ASC' ? '▲' : '▼') : '▲▼') . "</a></th>
                    <th><a href='?" . http_build_query(array_merge($_GET, ['order_by' => 'Date_last_action', 'order_dir' => $orderBy === 'Date_last_action' && $orderDir === 'ASC' ? 'DESC' : 'ASC'])) . "'>Date_last_action" . ($orderBy === 'Date_last_action' ? ($orderDir === 'ASC' ? '▲' : '▼') : '▲▼') . "</a></th>
                </tr>";

        // متغير للتعداد
        $counter = 1 + $offset;

        while($row = $result->fetch_assoc()) {
            echo "<tr>
                    <td>" . $counter . "</td>
                    <td>" . $row["VIN"] . "</td>
                    <td>" . $row["Model"] . "</td>
                    <td>" . $row["Variant"] . "</td>
                    <td>" . $row["Date_last_action"] . "</td>
                  </tr>";
            // زيادة التعداد
            $counter++;
        }
        echo "</table>";

        // حساب العدد الإجمالي للصفوف
        $countSql = "SELECT COUNT(*) AS totalRows FROM change_stock_1 $whereSQL";
        $countResult = $conn->query($countSql);
        $totalRows = $countResult->fetch_assoc()['totalRows'];
        $totalPages = ceil($totalRows / $rowsPerPage);

        // عرض روابط تقسيم الصفحات
        echo "<nav aria-label='Page navigation'>
                <ul class='pagination'>";
        for ($i = 1; $i <= $totalPages; $i++) {
            echo "<li" . ($i == $currentPage ? " class='active'" : "") . "><a href='?" . http_build_query(array_merge($_GET, ['page' => $i])) . "'>$i</a></li>";
        }
        echo "  </ul>
              </nav>";
    } else {
        echo "0 results";
    }

    // إغلاق الاتصال بقاعدة البيانات
    $conn->close();
    ?>
</body>
</html>
